<?php

use Illuminate\Support\Facades\Route;
use Spatie\Honeypot\ProtectAgainstSpam;

/*
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 */
Route::namespace('Bongo\Review\Http\Controllers')
     ->middleware('web')
     ->group(function () {

         // Frontend Routes...
         Route::namespace('Frontend')
              ->as('frontend.')
              ->group(function () {

                  // Review
                  Route::prefix(config('review.prefix'))
                       ->as('review.')
                       ->group(function () {

                           Route::get('/')
                                ->name('index')
                                ->uses('ReviewController@index');

                           Route::get('{uuid}')
                                ->name('show')
                                ->uses('ReviewController@show');

                           Route::post('store')
                                ->name('store')
                                ->uses('ReviewController@store')
                                ->middleware(ProtectAgainstSpam::class);

                       });
              });
     });
