<?php

namespace Bongo\Review\Seeders;

use Bongo\Package\Models\Package;
use Bongo\Package\Traits\SeedsPackage;
use Illuminate\Database\Seeder;

/**
 * Class PackageSeeder.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Review\Seeders
 */
class PackageSeeder extends Seeder
{
    use SeedsPackage;

    /**
     * Run the seeder.
     *
     * @return void
     */
    public function run()
    {
        $this->package([
            'name'       => 'Review',
            'key'        => 'review',
            'route'      => 'backend.review',
            'icon'       => 'review',
            'status'     => Package::ACTIVE,
            'is_visible' => Package::VISIBLE,
        ]);
    }
}
