@extends('framework::backend.layouts.app')

@section('content')

    @component('blade::content_header')
        {{ $review->name }}
        @slot('actions')
            @deleteButton(['name' => trans('review::backend.delete'), 'url' => route('backend.review.destroy', $review->id)])
            @backButton(['name' => trans('review::backend.index'), 'url' => route('backend.review.index')])
            @editButton(['name' => trans('review::backend.edit'), 'url' => route('backend.review.edit', $review->id)])
        @endslot
    @endcomponent

    @component('blade::content_body')
        <section class="md:grid md:grid-cols-2 md:gap-6">
            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4">
                        <div class="sm:col-span-1">
                            @static(['name' => 'Title', 'value' => $review->title])
                        </div>
                        <div class="sm:col-span-1">
                            @static(['name' => 'Content', 'value' => $review->content])
                        </div>
                    </div>
                @endcomponent
            </div>

            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2 lg:grid-cols">
                        <div class="sm:col-span-2">
                            @static(['name' => 'Date', 'value' => !empty($review->date) ? $review->date->format('d/m/Y') : null])
                        </div>
                        <div class="sm:col-span-1">
                            @static(['name' => 'Status', 'value' => ucwords($review->status)])
                        </div>
                        <div class="sm:col-span-1">
                            @static(['name' => 'Rating', 'value' => $review->rating . ' Star'])
                        </div>
                        <div class="sm:col-span-1">
                            @static(['name' => 'Full Name', 'value' => $review->name])
                        </div>
                        <div class="sm:col-span-1">
                            @static(['name' => 'Email', 'value' => $review->email])
                        </div>
                    </div>
                @endcomponent
            </div>
        </section>
    @endcomponent
@stop
