@extends('framework::frontend.layouts.app')

@section('body_class', 'reviews-page')
@section('meta_title', setting('package::review.meta_title', ucwords(config('review.prefix'))))
@section('meta_description', setting('package::review.meta_description', ucwords(config('review.prefix'))))

@section('content')
    <div class="container py-5">

        @if(isset($reviews) && count($reviews) > 0)
            <div class="row">
                <div class="col-lg-4 order-lg-2">
                    <aside class="sticky-lg-top">
                        @include('review::frontend.partials.summary')
                        @include('review::frontend.partials.form')
                    </aside>
                </div>
                <div class="col-lg-8 order-lg-1">
                    <section class="reviews">
                        <div class="row row-cols-1">
                            @foreach($reviews as $review)
                                <div class="col pb-0 mb-4">
                                    @include('review::frontend.partials.review')
                                </div>
                            @endforeach
                        </div>
                    </section>
                    <section class="reviews-meta mt-4">
                        <div class="row align-items-center">
                            <div class="col-md-6 col-lg-3 text-right mb-2 text-md-left mb-md-0">
                                <span class="text-muted text-sm">
                                    Showing {{ $reviews->count() }} of {{ $reviews->total() }}
                                </span>
                            </div>
                            <div class="col-md-6 col-lg-9">
                                {{ $reviews->onEachSide(1)->links('framework::frontend.layouts.partials.pagination') }}
                            </div>
                        </div>
                    </section>
                </div>
            </div>
        @else
            <section class="no-reviews mt-5 text-center">
                <h2 class="mb-4 text-muted">NO REVIEWS FOUND...</h2>
                <a class="btn btn-primary" href="/">
                    Return to homepage
                </a>
            </section>
        @endif

    </div>
@stop
