<article id="{{ $review->uuid }}" class="card h-100 review">

    <div class="card-header">
        <div class="row align-items-center">
            <div class="col">
                <div class="review-name">
                    {{ $review->name }}
                </div>
                @if(!empty($review->date))
                    <div class="review-date">
                        {{ $review->date->format('jS F Y') }}
                    </div>
                @endif
            </div>
            <div class="col">
                <div class="rating-stars text-right">
                    <span class="fa fa-star {{ $review->rating >= 1 ? 'checked' : '' }}"></span>
                    <span class="fa fa-star {{ $review->rating >= 2 ? 'checked' : '' }}"></span>
                    <span class="fa fa-star {{ $review->rating >= 3 ? 'checked' : '' }}"></span>
                    <span class="fa fa-star {{ $review->rating >= 4 ? 'checked' : '' }}"></span>
                    <span class="fa fa-star {{ $review->rating >= 5 ? 'checked' : '' }}"></span>
                </div>
            </div>
        </div>
    </div>

    <div class="card-body">
        <h5 class="card-title">
            <a class="card-link" href="{{ route('frontend.review.show', $review->uuid) }}">
                {{ $review->title }}
            </a>
        </h5>
        <p class="card-text">
			{{ $review->content }}
        </p>
    </div>
</article>
