<?php

namespace Bongo\Setting\Events;

use Bongo\Setting\Models\Setting;
use Bongo\User\Models\User;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class SettingUpdated
{
    use Dispatchable;
    use InteractsWithSockets;
    use SerializesModels;

    public Setting $setting;

    public array $changes;

    public Authenticatable|User $user;

    public function __construct(Setting $setting, array $changes = [])
    {
        $this->setting = $setting;
        $this->changes = $changes;
        $this->user = user();
    }
}
