<?php

namespace Bongo\Setting\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateEnvironment extends FormRequest
{
    public function messages(): array
    {
        return [
            'database_host.regex' => "Database host can only contain letters, numbers, dots, dashes, underscores, colons and forward slashes.",
            'database_password.regex' => "Database password can only contain letters, numbers, dots, dashes and underscores.",

            'mail_host.regex' => "Mail host can only contain letters, numbers, dots, dashes, underscores, colons and forward slashes.",
            'mail_password.regex' => "Mail password can only contain letters, numbers, dots, dashes and underscores.",
        ];
    }

    public function rules(): array
    {
        //$settingTable = (new setting)->getTable();

        return [
            'app_url' => ['required', 'url'],
            'environment' => ['required', 'string', 'max:50', 'alpha'],
            'app_debug' => ['required', 'string', 'alpha'],

            'database_host' => ['required', 'string', 'max:50', 'regex:/^[A-Za-z0-9:\/\/._-]+$/i'],
            'database_name' => ['required', 'string', 'max:50', 'alpha_dash'],
            'database_username' => ['required', 'string', 'max:50', 'alpha_dash'],
            'database_password' => ['nullable', 'string', 'max:50', 'regex:/^[A-Za-z0-9#?!@$%^&*~._-]+$/i'],

            'mail_host' => ['required', 'string', 'max:50', 'regex:/^[A-Za-z0-9:\/\/._-]+$/i'],
            'mail_port' => ['required', 'string', 'numeric'],

            'mail_username' => ['required', 'string', 'max:50', 'email'],
            'mail_password' => ['required', 'string', 'max:50', 'regex:/^[A-Za-z0-9#?!@$%^&*~._-]+$/i'],
            'mail_from_name' => ['required', 'string', 'max:50'],
            'mail_from_address' => ['required', 'string', 'max:50', 'email'],
        ];
    }
}
