<?php

namespace Bongo\Setting\Listeners;

use Bongo\Setting\Actions\CompileCss;
use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Contracts\Queue\ShouldQueue;
use ScssPhp\ScssPhp\Exception\SassException;

class UpdateFrontendCss implements ShouldQueue
{
    /**
     * @throws BindingResolutionException
     * @throws SassException
     */
    public function handle($event): void
    {
        // Update the custom.css file
        setting()->setCustomCss($event->customCss);

        // Re-compile the css
        (new CompileCss())->execute();
    }
}
