<?php

use Bongo\Setting\Interfaces\DataTypes;
use Bongo\Setting\Interfaces\Groups;
use Bongo\Setting\Interfaces\InputTypes;
use Bongo\Setting\Interfaces\Namespaces;
use Bongo\Setting\Models\Setting;
use Bongo\Setting\Seeders\DataSeeder;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schema;

class CreateSettingsTable extends Migration
{
    public function up()
    {
        if (! Schema::hasTable('settings')) {
            Schema::create('settings', function (Blueprint $table) {
                $table->increments('id');

                $table->string('namespace')
                    ->default(Namespaces::SYSTEM)
                    ->index();

                $table->string('group')
                    ->default(Groups::MISC)
                    ->index();

                $table->string('name');
                $table->string('key')->index();
                $table->text('value')->nullable();
                $table->string('rules')->nullable();
                $table->text('options')->nullable();

                $table->enum('type', InputTypes::INPUT_TYPES)
                    ->default(InputTypes::INPUT);

                $table->enum('data', DataTypes::DATA_TYPES)
                    ->default(DataTypes::STRING);

                $table->unsignedInteger('sort_order')
                    ->nullable();

                $table->unsignedTinyInteger('is_visible')
                    ->default(1);

                $table->timestamps();
                $table->index(['namespace', 'group', 'key'], 'settings_ngk_index');
            });
        }

        // If the permissions table exists then seed the permissions
        if (Schema::hasTable('settings')) {
            Artisan::call('db:seed', ['--class' => DataSeeder::class , '--force' => true]);
        }
    }

    public function down()
    {
        Schema::dropIfExists('settings');
    }
}
