<?php

namespace Bongo\Setting\Services;

use Illuminate\Http\Request;

class RobotsManager
{
    private string $robotsPath;

    public function __construct()
    {
        $this->robotsPath = public_path('robots.txt');

        // Make sure the file exists
        if (! file_exists($this->robotsPath)) {
            touch($this->robotsPath);
        }
    }

    public function get(): false|string
    {
        return file_get_contents($this->robotsPath);
    }

    public function set(Request $request): void
    {
        // Index settings
        $robotsFileData = 'User-Agent: '.'*'."\n";
        $robotsFileData .= 'Disallow: '."\n";
        $robotsFileData .= 'User-Agent: '.'googlebot'."\n";
        $robotsFileData .= 'Disallow: '."\n";
        $robotsFileData .= 'User-Agent: '.'googlebot-image'."\n";
        $robotsFileData .= 'Disallow: '."\n\n";

        // Sitemap settings
        $robotsFileData .= 'Sitemap: '.$request->app_url.'/sitemap.xml'."\n\n";

        // Save the file
        file_put_contents($this->robotsPath, $robotsFileData);
    }
}
