@extends('framework::backend.layouts.app')

@section('content')
    <form method="POST" action="{{ route('backend.setting.system.update') }}">
        {{ csrf_field() }}

        @component('blade::content_header')
            {{ trans('setting::backend.edit') }}
            @slot('actions')
                @backButton(['name' => trans('setting::backend.index'), 'url' => route('backend.setting.index')])
                @saveButton(['name' => trans('setting::backend.update')])
            @endslot
        @endcomponent

        @component('blade::content_body')
            @include('setting::backend.partials.navigation')
            <div class="tabs-container">

                <div class="md:grid md:grid-cols-2 md:gap-6">
                    @foreach(setting()->getByNamespace('system') as $group => $settings)
                        <div class="md:col-span-1">

                            @component('blade::card')
                                @slot('header')
                                    {{ ucwords(str_replace('_', ' ', $group)) }}
                                @endslot

                                {{-- Loop through the settings --}}
                                <div class="grid grid-cols-1 col-gap-4 row-gap-4 md:grid-cols-2">
                                    @foreach($settings as $key => $setting)
                                        <div class="col-span-1">
                                            @if($setting->isText())
                                                @include('setting::backend.partials.textarea')
                                            @elseif($setting->isCheckbox())
                                                @include('setting::backend.partials.checkbox')
                                            @elseif($setting->isColorPicker())
                                                @include('setting::backend.partials.color_picker')
                                            @elseif($setting->isDynamic())
                                                @include('setting::backend.partials.dynamic')
                                            @elseif($setting->isSelect())
                                                @include('setting::backend.partials.select')
                                            @else
                                                @include('setting::backend.partials.input')
                                            @endif
                                        </div>
                                    @endforeach

                                </div>
                            @endcomponent

                        </div>
                    @endforeach
                </div>

            </div>
        @endcomponent

    </form>
@stop
