<?php

namespace Bongo\Setting\Actions;

use Illuminate\Contracts\Container\BindingResolutionException;
use ScssPhp\ScssPhp\Compiler;
use ScssPhp\ScssPhp\Exception\CompilerException;

/**
 * Class CompileCss
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2022 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Setting\Actions
 */
class CompileCss
{
    /**
     * Execute the action
     */
    public function execute()
    {
        if (config('settings.memory_limit') && ! empty(config('settings.memory_limit'))) {
            ini_set('memory_limit', config('settings.memory_limit'));
        }

        try {
            // Get the variables & Re-compile the scss
            $variables = [
                'headerLogoHeight' => setting('theme::logo.header_height'),
                'mobileLogoHeight' => setting('theme::logo.mobile_height'),
                'stickyLogoHeight' => setting('theme::logo.sticky_height'),
                'footerLogoHeight' => setting('theme::logo.footer_height'),

                'skin' => setting('theme::layout.skin'),
                'primary' => setting('theme::color.primary'),
                'secondary' => setting('theme::color.secondary'),
                'tertiary' => setting('theme::color.tertiary'),
                'quaternary' => setting('theme::color.quaternary'),

                'color-5' => setting('theme::color.color_5'),
                'color-6' => setting('theme::color.color_6'),
                'color-7' => setting('theme::color.color_7'),
                'color-8' => setting('theme::color.color_8'),
            ];

            // Create the compiler and set the default resource paths
            $scss = new Compiler();
            $scss->setVariables($variables);
            $scss->setImportPaths([resource_path('sass')]);
            $scss->setFormatter('\ScssPhp\ScssPhp\Formatter\Compressed');

            // Options for debugging
            if (app()->isLocal() && env('DEBUG_CSS')) {
                $scss->setFormatter('\ScssPhp\ScssPhp\Formatter\Expanded');
                $scss->setLineNumberStyle(Compiler::LINE_COMMENTS);
                $scss->setSourceMapOptions([
                    'sourceMapWriteTo' => public_path('css/frontend.map'),
                    // absolute path to write .map file
                    'sourceMapURL' => '/css/frontend.map',
                    // relative or full url to the above .map file
                    'sourceMapFilename' => '/css/frontend.css',
                    // (optional) relative or full url to the .css file
                    'sourceMapBasepath' => public_path('css/'),
                    // partial path (server root) removed (normalized) to create a relative url
                    'sourceRoot' => '/',
                    // (optional) prepended to 'source' field entries for relocating source files
                ]);
            }

            // Imports, https://bootswatch.com/
            $skin = $variables['skin'];
            $variables = "skins/{$skin}/_variables.scss";
            $bootstrap = "bootstrap/bootstrap.scss";
            $overrides = "skins/{$skin}/_overrides.scss";
            $vendors = "vendor/index.scss";
            $components = "components/index.scss";
            $custom = "custom.scss";

            // Get the output and store it in the public directory
            $output = $scss->compile("
                @import '{$variables}';
                @import '{$bootstrap}';
                @import '{$overrides}';
                @import '{$vendors}';
                @import '{$components}';
                @import '{$custom}';
            ");

            // Store the contents in the public directory
            file_put_contents(public_path('css/frontend.css'), $output);

        } catch (BindingResolutionException|CompilerException $e) {
            log_exception($e);
            abort(500, 'An error occurred whilst trying to compile the css.');
        }
    }
}
