<?php

namespace Bongo\Setting\Events;

use Bongo\Setting\Models\Setting;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

/**
 * Class SettingUpdated
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Setting\Events
 */
class SettingUpdated
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * @var Setting
     */
    public Setting $setting;

    /**
     * @var array
     */
    public array $changes;

    /**
     * @var Authenticatable|null
     */
    public $user;

    /**
     * SettingCreated constructor.
     *
     * @param Setting $setting
     * @param array   $changes
     */
    public function __construct(Setting $setting, $changes = [])
    {
        $this->setting = $setting;
        $this->changes = $changes;
        $this->user    = user();
    }
}
