<?php

namespace Bongo\Setting\Listeners;

use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Contracts\Queue\ShouldQueue;

/**
 * Class UpdateFrontendJs
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Setting\Listeners
 */
class UpdateFrontendJs implements ShouldQueue
{
    /**
     * @param $event
     *
     * @throws BindingResolutionException
     */
    public function handle($event): void
    {
        // Update the custom.js file
        setting()->setCustomJs($event->customJs);
    }
}
