<?php

namespace Bongo\Setting\Listeners;

use Bongo\Package\Models\Package;
use Bongo\Gallery\Seeders\PackageSeeder;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Artisan;

/**
 * Class UpdateGalleryModuleStatus.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Setting\Listeners
 */
class UpdateGalleryModuleStatus implements ShouldQueue
{
    /**
     * @param $event
     */
    public function handle($event): void
    {
        // If the gallery module setting has been updated
        if ($event->setting->full_key=='package::gallery.gallery_module') {

            // Check if the module already exists
            if ($package = Package::where('key', 'gallery')->get()->first()) {
                $package->status = $event->setting->isEnabled() ? Package::ACTIVE : Package::INACTIVE;
                $package->save();

            } else { // This package must not exists
                Artisan::call('db:seed', ['--class' => PackageSeeder::class, '--force' => true]);
                Artisan::call('migrate', ['--path' => '/vendor/bongo/gallery/src/Migrations', '--force' => true]);
            }

            // Clear the package cache
            Artisan::call('cache:clear');
        }
    }
}
