<?php

use Bongo\Setting\Models\Setting;
use Bongo\Setting\Seeders\DataSeeder;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

/**
 * Class CreateSettingsTable.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 */
class CreateSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->increments('id');

            $table->string('namespace')->default('system')->index();
            $table->string('group')->default('misc')->index();

            $table->string('name');
            $table->string('key')->index();
            $table->text('value')->nullable();
            $table->string('rules')->nullable();
            $table->text('options')->nullable();

            $table->enum('type', [
                Setting::CHECKBOX,
                Setting::COLOR_PICKER,
                Setting::DATE_PICKER,
                Setting::INPUT,
                Setting::SELECT,
                Setting::TEXT
            ])->default(Setting::INPUT);

            $table->enum('data', [
                Setting::BOOLEAN,
                Setting::DECIMAL,
                Setting::INTEGER,
                Setting::JSON,
                Setting::STRING,
            ])->default(Setting::STRING);

            $table->unsignedInteger('sort_order')->nullable();
            $table->timestamps();
            $table->index(['namespace', 'group', 'key'], 'settings_ngk_index');
        });

        // If the permissions table exists then seed the permissions
        if (Schema::hasTable('settings')) {
            Artisan::call('db:seed', ['--class' => DataSeeder::class]);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('settings');
    }
}
