<?php

namespace Bongo\Setting\Models;

use Bongo\Framework\Models\AbstractModel;
use Bongo\Framework\Traits\HasKey;
use Bongo\Setting\Traits\HasType;

/**
 * Class Setting
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Lang\Models
 */
class Setting extends AbstractModel
{
    // State
    public const ENABLED = 1;
    public const DISABLED = 0;

    // Types
    public const CHECKBOX = 'checkbox';
    public const COLOR_PICKER = 'color_picker';
    public const DATE_PICKER = 'date_picker';
    public const INPUT = 'input';
    public const SELECT = 'select';
    public const TEXT = 'text';

    // Data
    public const BOOLEAN = 'boolean';
    public const DECIMAL = 'decimal';
    public const INTEGER = 'integer';
    public const JSON = 'json';
    public const STRING = 'string';

    // Namespace
    public const CLIENT = 'client';
    public const PACKAGE = 'package';
    public const THEME = 'theme';
    public const SYSTEM = 'system';

    // Group
    public const COLOR = 'color';
    public const COMPANY = 'company';
    public const CREDENTIALS = 'credentials';
    public const DEVELOPER = 'developer';
    public const ESTIMATE = 'estimate';
    public const GALLERY = 'gallery';
    public const LAYOUT = 'layout';
    public const LOGO = 'logo';
    public const MARKETING = 'marketing';
    public const MISC = 'misc';
    public const OFFICE = 'office';
    public const PAGE = 'page';
    public const POST = 'post';
    public const PROJECT = 'project';
    public const REVIEW = 'review';
    public const REGISTERED = 'registered';
    public const SOCIAL = 'social';

    // Traits
    use HasKey;
    use HasType;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'key',
        'value',
        'rules',
        'options',
        'type',
        'data',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'options' => 'array',
    ];

    /**
     * @return string
     */
    public function getFullKeyAttribute()
    {
        return "{$this->namespace}::{$this->group}.{$this->key}";
    }

    /**
     * @return bool
     */
    public function isEnabled(): bool
    {
        return $this->isCheckbox()
            && (int) $this->value === Setting::ENABLED;
    }

    /**
     * @return bool
     */
    public function isDisabled(): bool
    {
        return $this->isCheckbox()
            && (int) $this->value === Setting::DISABLED;
    }
}
