<?php

use Illuminate\Support\Facades\Route;

/*
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 */
Route::namespace('Bongo\Setting\Http\Controllers')
     ->middleware('web')
     ->group(function () {

         // Backend Routes...
         Route::namespace('Backend')
              ->middleware(['auth', 'developer'])
              ->prefix(config('settings.backend_prefix'))
              ->as('backend.')
              ->group(function () {

                  // setting
                  Route::as('setting.')
                       ->prefix('settings')
                       ->group(function () {

                           Route::get('/')
                                ->name('index')
                                ->uses('SettingController@edit');

                           Route::get('edit')
                                ->name('edit')
                                ->uses('SettingController@edit');

                           Route::post('update')
                                ->name('update')
                                ->uses('SettingController@update');

                           Route::get('clear-cache')
                                ->name('clear_cache')
                                ->uses('SettingController@clearCache');

                           Route::get('compile-css')
                                ->name('compile_css')
                                ->uses('SettingController@compileCss');

                           Route::get('generate-sitemap')
                                ->name('generate_sitemap')
                                ->uses('SettingController@generateSitemap');
                       });
              });
     });
