<?php

namespace Bongo\Setting\Seeders;

use Bongo\Package\Models\Package;
use Bongo\Setting\Models\Setting;
use Illuminate\Database\Seeder;

class DataSeeder extends Seeder
{
    public function run()
    {
        $this->setCompany();
        $this->setSocial();
        $this->setMarketing();
        $this->setOfficeAddress();
        $this->setRegisteredAddress();
        $this->setTheme();
        $this->setCredentials();
        $this->setDeveloper();
        $this->setMisc();
        $this->setPackages();

        $this->command->info('Settings have been updated :)');
    }

    private function setCompany()
    {
        $rows = [
            ['namespace' => Setting::CLIENT, 'group' => Setting::COMPANY, 'name' => 'Name', 'sort_order' => 1],
            ['namespace' => Setting::CLIENT, 'group' => Setting::COMPANY, 'name' => 'Trading Name', 'sort_order' => 2],
            ['namespace' => Setting::CLIENT, 'group' => Setting::COMPANY, 'name' => 'Email', 'sort_order' => 3],
            ['namespace' => Setting::CLIENT, 'group' => Setting::COMPANY, 'name' => 'BCC Email', 'sort_order' => 4],
            ['namespace' => Setting::CLIENT, 'group' => Setting::COMPANY, 'name' => 'Phone', 'sort_order' => 5],
            ['namespace' => Setting::CLIENT, 'group' => Setting::COMPANY, 'name' => 'Mobile', 'sort_order' => 6],
            ['namespace' => Setting::CLIENT, 'group' => Setting::COMPANY, 'name' => 'Website', 'sort_order' => 7],
            [
                'namespace' => Setting::CLIENT,
                'group' => Setting::COMPANY,
                'name' => 'Company Number',
                'sort_order' => 8,
            ],
            ['namespace' => Setting::CLIENT, 'group' => Setting::COMPANY, 'name' => 'Vat Number', 'sort_order' => 9],
            [
                'namespace' => Setting::CLIENT, 'group' => Setting::COMPANY, 'name' => 'Weekday Hours',
                'sort_order' => 10,
            ],
            [
                'namespace' => Setting::CLIENT,
                'group' => Setting::COMPANY,
                'name' => 'Weekend Hours',
                'sort_order' => 11,
            ],
        ];

        foreach ($rows as $row) {
            $this->createOrUpdateSetting($row);
        }
    }

    private function setSocial()
    {
        $rows = [
            ['namespace' => Setting::CLIENT, 'group' => Setting::SOCIAL, 'name' => 'Facebook', 'sort_order' => 1],
            ['namespace' => Setting::CLIENT, 'group' => Setting::SOCIAL, 'name' => 'Twitter', 'sort_order' => 2],
            ['namespace' => Setting::CLIENT, 'group' => Setting::SOCIAL, 'name' => 'Instagram', 'sort_order' => 3],
            ['namespace' => Setting::CLIENT, 'group' => Setting::SOCIAL, 'name' => 'Youtube', 'sort_order' => 4],
            ['namespace' => Setting::CLIENT, 'group' => Setting::SOCIAL, 'name' => 'Linkedin', 'sort_order' => 5],
            ['namespace' => Setting::CLIENT, 'group' => Setting::SOCIAL, 'name' => 'Pinterest', 'sort_order' => 6],
        ];

        foreach ($rows as $row) {
            $this->createOrUpdateSetting($row);
        }
    }

    private function setMarketing()
    {
        $rows = [
            [
                'namespace' => Setting::CLIENT, 'group' => Setting::MARKETING, 'name' => 'Google Ads Phone',
                'sort_order' => 1,
            ],
            [
                'namespace' => Setting::CLIENT, 'group' => Setting::MARKETING, 'name' => 'Facebook Ads Phone',
                'sort_order' => 2,
            ],
            [
                'namespace' => Setting::CLIENT, 'group' => Setting::MARKETING, 'name' => 'Linkedin Ads Phone',
                'sort_order' => 3,
            ],
        ];

        foreach ($rows as $row) {
            $this->createOrUpdateSetting($row);
        }
    }

    private function setOfficeAddress()
    {
        $rows = [
            ['namespace' => Setting::CLIENT, 'group' => Setting::OFFICE, 'name' => 'Line 1', 'sort_order' => 1],
            ['namespace' => Setting::CLIENT, 'group' => Setting::OFFICE, 'name' => 'Line 2', 'sort_order' => 2],
            ['namespace' => Setting::CLIENT, 'group' => Setting::OFFICE, 'name' => 'Line 3', 'sort_order' => 3],
            ['namespace' => Setting::CLIENT, 'group' => Setting::OFFICE, 'name' => 'City', 'sort_order' => 4],
            ['namespace' => Setting::CLIENT, 'group' => Setting::OFFICE, 'name' => 'County', 'sort_order' => 5],
            ['namespace' => Setting::CLIENT, 'group' => Setting::OFFICE, 'name' => 'Postcode', 'sort_order' => 6],
            ['namespace' => Setting::CLIENT, 'group' => Setting::OFFICE, 'name' => 'Country', 'sort_order' => 7],
        ];

        foreach ($rows as $row) {
            $this->createOrUpdateSetting($row);
        }
    }

    private function setRegisteredAddress()
    {
        $rows = [
            ['namespace' => Setting::CLIENT, 'group' => Setting::REGISTERED, 'name' => 'Line 1', 'sort_order' => 1],
            ['namespace' => Setting::CLIENT, 'group' => Setting::REGISTERED, 'name' => 'Line 2', 'sort_order' => 2],
            ['namespace' => Setting::CLIENT, 'group' => Setting::REGISTERED, 'name' => 'Line 3', 'sort_order' => 3],
            ['namespace' => Setting::CLIENT, 'group' => Setting::REGISTERED, 'name' => 'City', 'sort_order' => 4],
            ['namespace' => Setting::CLIENT, 'group' => Setting::REGISTERED, 'name' => 'County', 'sort_order' => 5],
            ['namespace' => Setting::CLIENT, 'group' => Setting::REGISTERED, 'name' => 'Postcode', 'sort_order' => 6],
            ['namespace' => Setting::CLIENT, 'group' => Setting::REGISTERED, 'name' => 'Country', 'sort_order' => 7],
        ];

        foreach ($rows as $row) {
            $this->createOrUpdateSetting($row);
        }
    }

    private function setTheme()
    {
        $rows = [
            [
                'namespace' => Setting::THEME,
                'group' => Setting::LOGO,
                'name' => 'Default',
                'value' => '/images/logo.png',
                'sort_order' => 1,
            ],
            [
                'namespace' => Setting::THEME,
                'group' => Setting::LOGO,
                'name' => 'Light',
                'value' => '/images/logo_light.png',
                'sort_order' => 2,
            ],
            [
                'namespace' => Setting::THEME,
                'group' => Setting::LOGO,
                'name' => 'Dark',
                'value' => '/images/logo_dark.png',
                'sort_order' => 3,
            ],
            [
                'namespace' => Setting::THEME,
                'group' => Setting::LOGO,
                'name' => 'Header Height',
                'value' => 48,
                'sort_order' => 4,
            ],
            [
                'namespace' => Setting::THEME,
                'group' => Setting::LOGO,
                'name' => 'Mobile Height',
                'value' => 30,
                'sort_order' => 5,
            ],
            [
                'namespace' => Setting::THEME,
                'group' => Setting::LOGO,
                'name' => 'Sticky Height',
                'value' => 33,
                'sort_order' => 6,
            ],
            [
                'namespace' => Setting::THEME,
                'group' => Setting::LOGO,
                'name' => 'Footer Height',
                'value' => 33,
                'sort_order' => 7,
            ],
            [
                'namespace' => Setting::THEME,
                'group' => Setting::COLOR,
                'name' => 'Primary',
                'value' => '#BED62F',
                'sort_order' => 1,
                'type' => Setting::COLOR_PICKER,
            ],
            [
                'namespace' => Setting::THEME,
                'group' => Setting::COLOR,
                'name' => 'Secondary',
                'value' => '#F8931D',
                'sort_order' => 2,
                'type' => Setting::COLOR_PICKER,
            ],
            [
                'namespace' => Setting::THEME,
                'group' => Setting::COLOR,
                'name' => 'Tertiary',
                'value' => '#1E79BF',
                'sort_order' => 3,
                'type' => Setting::COLOR_PICKER,
            ],
            [
                'namespace' => Setting::THEME,
                'group' => Setting::COLOR,
                'name' => 'Quaternary',
                'value' => '#D62F6B',
                'sort_order' => 4,
                'type' => Setting::COLOR_PICKER,
            ],
            [
                'namespace' => Setting::THEME,
                'group' => Setting::COLOR,
                'name' => 'Color 5',
                'value' => '#DC2121',
                'sort_order' => 5,
                'type' => Setting::COLOR_PICKER,
            ],
            [
                'namespace' => Setting::THEME,
                'group' => Setting::COLOR,
                'name' => 'Color 6',
                'value' => '#9C0F83',
                'sort_order' => 6,
                'type' => Setting::COLOR_PICKER,
            ],
            [
                'namespace' => Setting::THEME,
                'group' => Setting::COLOR,
                'name' => 'Color 7',
                'value' => '#9C510F',
                'sort_order' => 7,
                'type' => Setting::COLOR_PICKER,
            ],
            [
                'namespace' => Setting::THEME,
                'group' => Setting::COLOR,
                'name' => 'Color 8',
                'value' => '#F3036B',
                'sort_order' => 8,
                'type' => Setting::COLOR_PICKER,
            ],
            [
                'namespace' => Setting::THEME,
                'group' => Setting::LAYOUT,
                'name' => 'Skin',
                'value' => 'default',
                'sort_order' => 9,
                'type' => Setting::SELECT,
                'options' => [
                    'cerulean',
                    'cosmo',
                    'custom',
                    'cyborg',
                    'darkly',
                    'default',
                    'flatly',
                    'journal',
                    'litera',
                    'lumen',
                    'lux',
                    'materia',
                    'minty',
                    'pulse',
                    'sandstone',
                    'simplex',
                    'sketchy',
                    'slate',
                    'solar',
                    'spacelab',
                    'superhero',
                    'united',
                    'yeti',
                ],
            ],
            [
                'namespace' => Setting::THEME,
                'group' => Setting::LAYOUT,
                'name' => 'Header',
                'value' => 'header_1',
                'sort_order' => 10,
                'type' => Setting::SELECT,
                'options' => ['header_1', 'header_2', 'header_3', 'header_4', 'header_5'],
            ],
            [
                'namespace' => Setting::THEME,
                'group' => Setting::LAYOUT,
                'name' => 'Sticky Header',
                'value' => Setting::DISABLED,
                'sort_order' => 11,
                'type' => Setting::CHECKBOX,
                'data' => Setting::BOOLEAN,
            ],
            [
                'namespace' => Setting::THEME,
                'group' => Setting::LAYOUT,
                'name' => 'Transparent Header',
                'value' => Setting::DISABLED,
                'sort_order' => 12,
                'type' => Setting::CHECKBOX,
                'data' => Setting::BOOLEAN,
            ],
            [
                'namespace' => Setting::THEME,
                'group' => Setting::LAYOUT,
                'name' => 'Heading',
                'value' => 'heading_1',
                'sort_order' => 13,
                'type' => Setting::SELECT,
                'options' => ['heading_1', 'heading_2', 'heading_3', 'heading_4', 'heading_5'],
            ],
            [
                'namespace' => Setting::THEME,
                'group' => Setting::LAYOUT,
                'name' => 'Footer',
                'value' => 'footer_1',
                'sort_order' => 14,
                'type' => Setting::SELECT,
                'options' => ['footer_1', 'footer_2', 'footer_3', 'footer_4', 'footer_5'],
            ],
            [
                'namespace' => Setting::THEME,
                'group' => Setting::LAYOUT,
                'name' => 'Footer Text',
                'sort_order' => 15,
                'type' => Setting::TEXT,
            ],
        ];

        foreach ($rows as $row) {
            $this->createOrUpdateSetting($row);
        }
    }

    private function setCredentials()
    {
        $rows = [
            [
                'namespace' => Setting::SYSTEM,
                'group' => Setting::CREDENTIALS,
                'name' => 'Facebook App Id',
            ],
            [
                'namespace' => Setting::SYSTEM,
                'group' => Setting::CREDENTIALS,
                'name' => 'Facebook Pixel Id',
            ],
            [
                'namespace' => Setting::SYSTEM,
                'group' => Setting::CREDENTIALS,
                'name' => 'Google Analytics Id',
            ],
            [
                'namespace' => Setting::SYSTEM,
                'group' => Setting::CREDENTIALS,
                'name' => 'Google Analytics Type',
                'value' => 'analytics',
                'type' => Setting::SELECT,
                'options' => ['analytics', 'tag_manager'],
            ],
            [
                'namespace' => Setting::SYSTEM,
                'group' => Setting::CREDENTIALS,
                'name' => 'Google Geocoding Api Key',
            ],
            [
                'namespace' => Setting::SYSTEM,
                'group' => Setting::CREDENTIALS,
                'name' => 'Google Maps Api Key',
            ],
            [
                'namespace' => Setting::SYSTEM,
                'group' => Setting::CREDENTIALS,
                'name' => 'Google ReCaptcha Site Key',
            ],
            [
                'namespace' => Setting::SYSTEM,
                'group' => Setting::CREDENTIALS,
                'name' => 'Google ReCaptcha Secret Key',
            ],
            [
                'namespace' => Setting::SYSTEM,
                'group' => Setting::CREDENTIALS,
                'name' => 'Mailchimp Url',
            ],
            [
                'namespace' => Setting::SYSTEM,
                'group' => Setting::CREDENTIALS,
                'name' => 'Real Green Api Key',
            ],
        ];

        foreach ($rows as $row) {
            $this->createOrUpdateSetting($row);
        }
    }

    private function setMisc()
    {
        $rows = [
            [
                'namespace' => Setting::SYSTEM,
                'group' => Setting::MISC,
                'name' => 'Version',
                'value' => '2.0.0',
                'data' => Setting::DECIMAL,
            ],
            [
                'namespace' => Setting::SYSTEM,
                'group' => Setting::MISC,
                'name' => 'Site Visibility',
                'value' => 'noindex',
                'sort_order' => 6,
                'type' => Setting::SELECT,
                'options' => ['index', 'noindex'],
            ],
        ];

        foreach ($rows as $row) {
            $this->createOrUpdateSetting($row);
        }
    }

    private function setDeveloper()
    {
        $rows = [
            [
                'namespace' => Setting::SYSTEM,
                'group' => Setting::DEVELOPER,
                'name' => 'Credit Link',
                'value' => 'https://www.designtec.co.uk/website-design-norwich',
                'type' => Setting::INPUT,
                'data' => Setting::STRING,
            ],
            [
                'namespace' => Setting::SYSTEM,
                'group' => Setting::DEVELOPER,
                'name' => 'Credit Text',
                'value' => 'Website Design Norwich',
                'type' => Setting::INPUT,
                'data' => Setting::STRING,
            ],
            [
                'namespace' => Setting::SYSTEM,
                'group' => Setting::DEVELOPER,
                'name' => 'Credit Type',
                'value' => 'follow',
                'type' => Setting::SELECT,
                'options' => ['follow', 'nofollow'],
            ],
        ];

        foreach ($rows as $row) {
            $this->createOrUpdateSetting($row);
        }
    }

    private function setPackages()
    {
        $rows = [
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::ESTIMATE,
                'name' => 'Estimate Module',
                'value' => Package::INACTIVE,
                'type' => Setting::CHECKBOX,
                'data' => Setting::BOOLEAN,
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::ESTIMATE,
                'name' => 'Real Green Module',
                'key' => 'real_green_module',
                'value' => Package::INACTIVE,
                'type' => Setting::CHECKBOX,
                'data' => Setting::BOOLEAN,
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::ESTIMATE,
                'name' => 'Step 1',
                'value' => 'Details',
                'sort_order' => 2,
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::ESTIMATE,
                'name' => 'Step 2',
                'value' => 'Measure',
                'sort_order' => 3,
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::ESTIMATE,
                'name' => 'Step 3',
                'value' => 'Quote',
                'sort_order' => 4,
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::ESTIMATE,
                'name' => 'More Assistance Url',
                'value' => '/more-assistance',
                'sort_order' => 5,
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::ESTIMATE,
                'name' => 'Terms Url',
                'value' => '/terms-conditions',
                'sort_order' => 6,
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::ESTIMATE,
                'name' => 'Confirmation Url',
                'value' => '/thank-you',
                'sort_order' => 7,
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::ESTIMATE,
                'name' => 'Sales Email',
                'value' => 'sales@designtec.co.uk',
                'sort_order' => 8,
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::ESTIMATE,
                'name' => 'Postcode Placeholder',
                'value' => 'e.g SP20AH',
                'sort_order' => 9,
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::ESTIMATE,
                'name' => 'Radius In Miles',
                'value' => '50',
                'sort_order' => 10,
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::ESTIMATE,
                'name' => 'From Latitude',
                'value' => '52.5628574',
                'sort_order' => 11,
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::ESTIMATE,
                'name' => 'From Longitude',
                'value' => '1.3405801',
                'sort_order' => 12,
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::GALLERY,
                'name' => 'Gallery Module',
                'value' => Package::INACTIVE,
                'type' => Setting::CHECKBOX,
                'data' => Setting::BOOLEAN,
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::POST,
                'name' => 'Post Module',
                'value' => Package::INACTIVE,
                'type' => Setting::CHECKBOX,
                'data' => Setting::BOOLEAN,
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::POST,
                'name' => 'Related Type',
                'value' => 'off',
                'sort_order' => 2,
                'type' => Setting::SELECT,
                'options' => ['off', 'random', 'next_previous', 'random_next_previous'],
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::POST,
                'name' => 'Meta Title',
                'sort_order' => 3,
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::POST,
                'name' => 'Meta Description',
                'sort_order' => 4,
                'type' => Setting::TEXT,
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::PROJECT,
                'name' => 'Project Module',
                'value' => Package::INACTIVE,
                'type' => Setting::CHECKBOX,
                'data' => Setting::BOOLEAN,
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::PROJECT,
                'name' => 'Related Type',
                'value' => 'off',
                'sort_order' => 2,
                'type' => Setting::SELECT,
                'options' => ['off', 'random', 'next_previous', 'random_next_previous'],
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::PROJECT,
                'name' => 'Meta Title',
                'sort_order' => 3,
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::PROJECT,
                'name' => 'Meta Description',
                'sort_order' => 4,
                'type' => Setting::TEXT,
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::REVIEW,
                'name' => 'Review Module',
                'value' => Package::INACTIVE,
                'type' => Setting::CHECKBOX,
                'data' => Setting::BOOLEAN,
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::REVIEW,
                'name' => 'Meta Title',
                'sort_order' => 3,
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::REVIEW,
                'name' => 'Meta Description',
                'sort_order' => 4,
                'type' => Setting::TEXT,
            ],
            [
                'namespace' => Setting::PACKAGE,
                'group' => Setting::PAGE,
                'name' => 'Number Of Pages',
                'value' => 8,
                'data' => Setting::INTEGER,
            ],
        ];

        foreach ($rows as $row) {
            $this->createOrUpdateSetting($row);
        }
    }

    private function createOrUpdateSetting($row): void
    {
        // Check if we already have this setting
        $setting = Setting::query()
            ->where('namespace', $row['namespace'])
            ->where('group', $row['group'])
            ->where('name', $row['name'])
            ->first();

        // If we dont then create it
        if (! $setting) {
            Setting::create([
                'namespace' => $row['namespace'],
                'group' => $row['group'],
                'name' => $row['name'],
                'value' => $row['value'] ?? null,
                'rules' => $row['rules'] ?? null,
                'options' => $row['options'] ?? null,
                'type' => $row['type'] ?? Setting::INPUT,
                'data' => $row['data'] ?? Setting::STRING,
                'sort_order' => $row['sort_order'] ?? null,
            ]);
        }
    }
}
