<?php

namespace Bongo\Setting\Services;

use Illuminate\Http\Request;

/**
 * Class RobotsManager
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Setting\Helpers
 */
class RobotsManager
{
    /**
     * @var string
     */
    private $robotsPath;

    /**
     * RobotsManager constructor.
     */
    public function __construct()
    {
        $this->robotsPath = public_path('robots.txt');

        // Make sure the file exists
        if (!file_exists($this->robotsPath)) {
            touch($this->robotsPath);
        }
    }

    /**
     * @return false|string
     */
    public function get()
    {
        return file_get_contents($this->robotsPath);
    }

    /**
     * @param Request $request
     */
    public function set(Request $request)
    {
        // Index settings
        $robotsFileData = 'User-Agent: ' . '*' . "\n";
        $robotsFileData .= 'Disallow: ' . "\n";
        $robotsFileData .= 'User-Agent: ' . 'googlebot' . "\n";
        $robotsFileData .= 'Disallow: ' . "\n";
        $robotsFileData .= 'User-Agent: ' . 'googlebot-image' . "\n";
        $robotsFileData .= 'Disallow: ' . "\n\n";

        // Sitemap settings
        $robotsFileData .= 'Sitemap: ' . $request->app_url . '/sitemap.xml' . "\n\n";

        // Save the file
        file_put_contents($this->robotsPath, $robotsFileData);
    }
}
