<?php

namespace Bongo\Setting;

use Bongo\Menu\Listeners\ClearMenuCache;
use Bongo\Setting\Events\CssUpdated;
use Bongo\Setting\Events\JsUpdated;
use Bongo\Setting\Listeners\UpdateEstimateModuleStatus;
use Bongo\Setting\Listeners\UpdateFrontendCss;
use Bongo\Setting\Listeners\UpdateFrontendJs;
use Bongo\Setting\Listeners\UpdateGalleryModuleStatus;
use Bongo\Setting\Listeners\UpdatePostModuleStatus;
use Bongo\Setting\Listeners\UpdateProjectModuleStatus;
use Bongo\Setting\Listeners\UpdateRealGreenModuleStatus;
use Bongo\Setting\Listeners\UpdateReviewModuleStatus;
use Bongo\Setting\Events\SettingUpdated;
use Bongo\Setting\Models\Setting;
use Bongo\Setting\Services\SettingManager;
use Bongo\Framework\Providers\AbstractServiceProvider;
use Exception;
use Illuminate\Foundation\AliasLoader;
use ReflectionException;

class SettingServiceProvider extends AbstractServiceProvider
{
    /** @var string */
    protected $module = 'setting';

    /** @var array */
    protected $listeners = [
        SettingUpdated::class => [
            UpdateEstimateModuleStatus::class,
            UpdateRealGreenModuleStatus::class,
            UpdateGalleryModuleStatus::class,
            UpdatePostModuleStatus::class,
            UpdateProjectModuleStatus::class,
            UpdateReviewModuleStatus::class,
            ClearMenuCache::class,
        ],
        CssUpdated::class => [
            UpdateFrontendCss::class,
        ],
        JsUpdated::class => [
            UpdateFrontendJs::class,
        ],
    ];

    /**
     * @throws Exception
     */
    public function register()
    {
        parent::register();
        $this->app->bind('setting_manager', SettingManager::class);
    }

    /**
     * @throws ReflectionException
     */
    public function boot()
    {
        parent::boot();
        AliasLoader::getInstance()->alias('Setting', Setting::class);

        // Once the app is booted include the helper functions
        $this->app->booted(function () {
            include __DIR__ . '/helpers.php';

            // Override the re-captcha keys
            $config = $this->app->make('config');
            $config->set('recaptchav3.sitekey', setting()->getReCaptchaSiteKey());
            $config->set('recaptchav3.secret', setting()->getReCaptchaSecretKey());
        });
    }
}
