<?php

namespace Bongo\Setting\Traits;

/**
 * Trait HasType.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Setting\Traits
 */
trait HasType
{
    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeCheckbox($query)
    {
        return $query->where('type', self::CHECKBOX);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeNotCheckbox($query)
    {
        return $query->where('type', '!=', self::CHECKBOX);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeColorPicker($query)
    {
        return $query->where('type', self::COLOR_PICKER);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeNotColorPicker($query)
    {
        return $query->where('type', '!=', self::COLOR_PICKER);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeInput($query)
    {
        return $query->where('type', self::INPUT);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeNotInput($query)
    {
        return $query->where('type', '!=', self::INPUT);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeSelect($query)
    {
        return $query->where('type', self::SELECT);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeNotSelect($query)
    {
        return $query->where('type', '!=', self::SELECT);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeText($query)
    {
        return $query->where('type', self::TEXT);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeNotText($query)
    {
        return $query->where('type', '!=', self::TEXT);
    }

    /**
     * @return bool
     */
    public function isCheckbox()
    {
        return $this->type === self::CHECKBOX;
    }

    /**
     * @return bool
     */
    public function isColorPicker()
    {
        return $this->type === self::COLOR_PICKER;
    }

    /**
     * @return bool
     */
    public function isInput()
    {
        return $this->type === self::INPUT;
    }

    /**
     * @return bool
     */
    public function isSelect()
    {
        return $this->type === self::SELECT;
    }

    /**
     * @return bool
     */
    public function isText()
    {
        return $this->type === self::TEXT;
    }
}
