@extends('framework::backend.layouts.app')

@section('content')
    <form method="POST" action="{{ route('backend.setting.update') }}">
        {{ csrf_field() }}

        @component('blade::content_header')
            {{ trans('setting::backend.edit') }}
            @slot('actions')
                @backButton(['name' => trans('setting::backend.index'), 'url' => route('backend.setting.index')])
                @saveButton(['name' => trans('setting::backend.update')])
            @endslot
        @endcomponent

        @component('blade::content_body')
            <tabs class-list="border-t border-gray-100">
                <tab name="Env" :selected="true">
                    @component('blade::card', ['cardClass' => 'mb-6'])
                        @slot('header')
                            Application Settings
                        @endslot
                        <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                            <div class="col-span-1">
                                @input([
                                    'label'       => 'URL',
                                    'name'        => 'app_url',
                                    'value'       => $env['APP_URL'] ?? null,
                                    'placeholder' => 'https://designtec.co.uk',
                                    'required'    => 'true'
                                ])
                            </div>
                            <div class="col-span-1">
                                @select([
                                    'label'    => 'Environment',
                                    'name'     => 'environment',
                                    'value'    => $env['APP_ENV'] ?? 'production',
                                    'options'  => [
                                        'production'  => 'Production',
                                        'staging'     => 'Staging',
                                        'development' => 'Development',
                                        'local'       => 'Local'
                                    ]
                                ])
                            </div>
                            <div class="col-span-1">
                                @select([
                                    'label'    => 'Debugging Enabled',
                                    'name'     => 'app_debug',
                                    'value'    => $env['APP_DEBUG'] ?? 'false',
                                    'options'  => ['false' => 'False', 'true' => 'True']
                                ])
                            </div>
                        </div>
                    @endcomponent

                    @component('blade::card', ['cardClass' => 'mb-6'])
                        @slot('header')
                            Database Settings
                        @endslot
                        <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                            <div class="col-span-1">
                                @input([
                                    'label'       => 'Host',
                                    'name'        => 'database_host',
                                    'value'       => $env['DB_HOST'] ?? '127.0.0.1',
                                    'placeholder' => '127.0.0.1',
                                    'required'    => 'true'
                                ])
                            </div>
                            <div class="col-span-1">
                                @input([
                                    'label'       => 'Name',
                                    'name'        => 'database_name',
                                    'value'       => $env['DB_DATABASE'] ?? null,
                                    'placeholder' => 'bongo_production',
                                    'required'    => 'true'
                                ])
                            </div>
                            <div class="col-span-1">
                                @input([
                                    'label'       => 'Username',
                                    'name'        => 'database_username',
                                    'value'       => $env['DB_USERNAME'] ?? null,
                                    'placeholder' => 'bongo_admin',
                                    'required'    => 'true'
                                ])
                            </div>
                            <div class="col-span-1">
                                @input([
                                    'label'       => 'Password',
                                    'name'        => 'database_password',
                                    'value'       => $env['DB_PASSWORD'] ?? null,
                                    'required'    => 'true'
                                ])
                            </div>
                        </div>
                    @endcomponent

                    @component('blade::card', ['cardClass' => 'mb-6'])
                        @slot('header')
                            Email Settings
                        @endslot

                        <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                            <div class="col-span-1">
                                @input([
                                    'label'       => 'Host',
                                    'name'        => 'mail_host',
                                    'value'       => $env['MAIL_HOST'] ?? 'casper-designtec.dedicated-solution.com',
                                    'placeholder' => 'casper-designtec.dedicated-solution.com',
                                    'required'    => 'true'
                                ])
                            </div>
                            <div class="col-span-1">
                                @input([
                                    'label'       => 'Port',
                                    'name'        => 'mail_port',
                                    'value'       => $env['MAIL_PORT'] ?? '587',
                                    'placeholder' => '587',
                                    'required'    => 'true'
                                ])
                            </div>
                            <div class="col-span-1">
                                @input([
                                    'label'       => 'Username',
                                    'name'        => 'mail_username',
                                    'value'       => $env['MAIL_USERNAME'] ?? null,
                                    'required'    => 'true'
                                ])
                            </div>
                            <div class="col-span-1">
                                @input([
                                    'label'       => 'Password',
                                    'name'        => 'mail_password',
                                    'value'       => $env['MAIL_PASSWORD'] ?? null,
                                    'required'    => 'true'
                                ])
                            </div>
                            <div class="col-span-1">
                                @input([
                                    'label'       => 'From Address',
                                    'name'        => 'mail_from_address',
                                    'value'       => $env['MAIL_FROM_ADDRESS'] ?? null,
                                    'placeholder' => 'support@designtec.co.uk',
                                    'required'    => 'true'
                                ])
                            </div>
                            <div class="col-span-1">
                                @input([
                                    'label'       => 'From Name',
                                    'name'        => 'mail_from_name',
                                    'value'       => $env['MAIL_FROM_NAME'] ?? null,
                                    'placeholder' => 'Support',
                                    'required'    => 'true'
                                ])
                            </div>
                        </div>
                    @endcomponent
                </tab>

                @foreach(setting()->allByNamespace() as $namespace => $groups)
                    <tab name="{{ ucwords(str_replace('_', ' ', $namespace)) }}">
                        <div class="md:grid md:grid-cols-2 md:gap-6">
                            @foreach($groups as $group => $settings)
                                <div class="md:col-span-1">

                                    @component('blade::card')
                                        @slot('header')
                                            {{ ucwords(str_replace('_', ' ', $group)) }}
                                        @endslot

                                        {{-- Loop through the settings --}}
                                        <div class="grid grid-cols-1 col-gap-4 row-gap-4 md:grid-cols-2">
                                            @foreach($settings as $key => $setting)
                                                <div class="col-span-1">
                                                    @if($setting->isText())
                                                        @include('setting::backend.partials.textarea')
                                                    @elseif($setting->isCheckbox())
                                                        @include('setting::backend.partials.checkbox')
                                                    @elseif($setting->isColorPicker())
                                                        @include('setting::backend.partials.color_picker')
                                                    @elseif($setting->isSelect())
                                                        @include('setting::backend.partials.select')
                                                    @else
                                                        @include('setting::backend.partials.input')
                                                    @endif
                                                </div>
                                            @endforeach

                                        </div>
                                    @endcomponent

                                </div>
                            @endforeach
                        </div>
                    </tab>
                @endforeach

                <tab name="Site CSS">
                    <custom-css-editor css="{{ setting()->getCustomCss() }}"></custom-css-editor>
                </tab>

                <tab name="Site JS">
                    <custom-js-editor js="{{ setting()->getCustomJs() }}"></custom-js-editor>
                </tab>
            </tabs>
        @endcomponent

    </form>
@stop
