@extends('framework::backend.layouts.app')

@section('header_javascript')
    <script src="https://cdn.rawgit.com/google/code-prettify/master/loader/run_prettify.js?skin=sunburst"></script>
@endsection

@section('content')

    @component('blade::content_header')
        {{ trans('setting::backend.index') }}
        @slot('actions')
            @backButton(['name' => trans('dashboard::backend.index')])
            @editButton(['name' => trans('setting::backend.edit'), 'url' => route('backend.setting.edit')])
        @endslot
    @endcomponent

    @component('blade::content_body')
        <tabs class-list="border-t border-gray-100">
            <tab name="Env" :selected="true">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])

                @endcomponent
            </tab>

            @foreach(setting()->allByNamespace() as $namespace => $groups)
                <tab name="{{ ucwords(str_replace('_', ' ', $namespace)) }}">
                    <div class="md:grid md:grid-cols-2 md:gap-6">
                        @foreach($groups as $group => $settings)
                            <div class="md:col-span-1">

                                @component('blade::card')
                                    @slot('header')
                                        {{ ucwords(str_replace('_', ' ', $group)) }}
                                    @endslot

                                    {{-- Loop through the settings --}}
                                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 md:grid-cols-2">
                                        @foreach($settings as $key => $setting)
                                            <div class="col-span-1">

                                                @if($setting->isCheckbox())
                                                    @static([
                                                        'name' => $setting->key,
                                                        'value' => ($setting->value == Setting::ENABLED ? 'Enabled' : 'Disabled')
                                                    ])
                                                @elseif($setting->isColorPicker())
                                                    @static([
                                                        'name' => $setting->key,
                                                        'value' => $setting->value,
                                                        'style' => "color:#FFF; background-color:{$setting->value};"
                                                    ])
                                                @else
                                                    @static(['name' => $setting->key, 'value' => $setting->value])
                                                @endif

                                            </div>
                                        @endforeach
                                    </div>
                                @endcomponent

                            </div>
                        @endforeach
                    </div>
                </tab>
            @endforeach

            <tab name="Site CSS">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <pre class="prettyprint" style="width: 100%; margin: 0; border-radius: 0; padding: .5rem;"><code class="text-xs">{{ setting()->getCustomCss() }}</code></pre>
                @endcomponent
            </tab>

            <tab name="Site JS">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <pre class="prettyprint" style="width: 100%; margin: 0; border-radius: 0; padding: .5rem;"><code class="text-xs">{{ setting()->getCustomJs() }}</code></pre>
                @endcomponent
            </tab>

        </tabs>
    @endcomponent

@stop
