<div class="form-group">
    <span class="text-sm leading-5 font-medium text-gray-500">
        {{ $setting->name }}
    </span>

    <div class="mt-1 relative rounded-sm shadow-sm">

        <select name="settings[{{ $setting->id }}]"
                class="form-input block w-full rounded-sm sm:text-sm sm:leading-5 pr-10"
        >
            @foreach($setting->options as $option)
                <option value="{{ $option }}"
                    {{ isset($setting->value) && $setting->value == $option ? 'selected' : '' }}
                >
                    {{ ucwords(str_replace('_', ' ', $option)) }}
                </option>
            @endforeach
        </select>

        <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-2 text-gray-500">
            <svg class="fill-current h-4 w-6" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                <path d="M9.293 12.95l.707.707L15.657 8l-1.414-1.414L10 10.828 5.757 6.586 4.343 8z"/>
            </svg>
        </div>
    </div>

</div>
