<?php

use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Contracts\Foundation\Application;

if (!function_exists('setting')) {
    /**
     * @param string|null $key
     * @param string|null $default
     *
     * @return Application|mixed
     * @throws BindingResolutionException
     */
    function setting($key = null, $default = null)
    {
        if (is_null($key)) {
            return app()->make('setting_manager');
        }

        return app()->make('setting_manager')->get($key, $default);
    }
}
