<?php

namespace Bongo\Setting\Http\Controllers\Backend;

use Bongo\Estimate\Maps\Circle;
use Bongo\Estimate\Maps\Path;
use Bongo\Estimate\Maps\RadiusMap;
use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Setting\Actions\ClearCache;
use Bongo\Setting\Actions\UpdateSettings;
use Illuminate\Http\Request;
use Illuminate\Http\RedirectResponse;
use Illuminate\View\View;

class EstimateController extends AbstractController
{
    public function index(): View
    {
        if (! package()->isEnabled('estimate')) {
            abort(404);
        }

        $areas = setting()->getEstimateAreas();
        if (! empty($areas) && count($areas) && ! empty(setting('system::credentials.google_maps_api_key'))) {

            // Create the map
            $radiusMap = (new RadiusMap())
                ->setKey(setting('system::credentials.google_maps_api_key'))
                ->setCenter(config('estimate.map_center', [52.600850, 1.175440]))
                ->setZoom(config('estimate.radius_map.zoom_level', 8));

            // Add the paths (Overlays)
            foreach ($areas as $area) {

                // Create a circle based on the area
                $coordinates = (new Circle())
                    ->setLatitude($area['latitude'])
                    ->setLongitude($area['longitude'])
                    ->setZoom($radiusMap->getZoom())
                    ->setRadius($area['radius'])
                    ->getCoordinates();

                // Convert the coordinates to a path
                $path = (new Path())
                    ->setCoordinates($coordinates)
                    ->setFillColor($area['fill'])
                    ->setStrokeColor($area['stroke']);

                $radiusMap->addPath($path);
            }

            return view('setting::backend.estimate.index')->with([
                'radiusMapUrl' => $radiusMap->generateUrl(),
            ]);
        }

        return view('setting::backend.estimate.index');
    }

    public function update(Request $request): RedirectResponse
    {
        UpdateSettings::execute($request->get('settings'));
        ClearCache::execute();

        return redirect()
            ->route('backend.setting.estimate.index')
            ->success(trans('setting::backend.update_success'));
    }
}
