<?php

namespace Bongo\Setting\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Setting\Events\JsUpdated;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;

class SiteJsController extends AbstractController
{
    public function index(): View
    {
        return view('setting::backend.site_js.index');
    }

    public function update(Request $request): RedirectResponse
    {
        event(new JsUpdated($request->get('custom_js')));

        return redirect()
            ->route('backend.setting.site_js.index')
            ->success(trans('setting::backend.update_success'));
    }
}
