<?php

namespace Bongo\Setting\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Setting\Actions\ClearCache;
use Bongo\Setting\Actions\UpdateSettings;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;

class SystemController extends AbstractController
{
    public function index(): View
    {
        return view('setting::backend.system.index');
    }

    public function update(Request $request): RedirectResponse
    {
        UpdateSettings::execute($request->get('settings'));
        ClearCache::execute();

        return redirect()
            ->route('backend.setting.system.index')
            ->success(trans('setting::backend.update_success'));
    }
}
