<?php

namespace Bongo\Setting\Listeners;

use Bongo\Package\Models\Package;
use Bongo\Project\Seeders\DataSeeder;
use Bongo\Project\Seeders\PackageSeeder;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Artisan;

class UpdateProjectModuleStatus implements ShouldQueue
{
    public function handle($event): void
    {
        // If the project module setting has been updated
        if ($event->setting->full_key == 'package::project.project_module') {

            // Check if the module already exists
            if ($package = Package::where('key', 'project')->get()->first()) {
                $package->status = $event->setting->isEnabled() ? Package::ACTIVE : Package::INACTIVE;
                $package->save();

            } else { // This package must not exists
                Artisan::call('db:seed', ['--class' => PackageSeeder::class, '--force' => true]);
                Artisan::call('migrate', ['--path' => '/vendor/bongo/project/src/Migrations', '--force' => true]);
            }

            // Clear the package cache
            Artisan::call('cache:clear');
        }
    }
}
