<?php

namespace Bongo\Setting\Traits;

trait HasType
{
    public function scopeCheckbox($query)
    {
        return $query->where('type', self::CHECKBOX);
    }

    public function scopeNotCheckbox($query)
    {
        return $query->where('type', '!=', self::CHECKBOX);
    }

    public function isCheckbox(): bool
    {
        return $this->type === self::CHECKBOX;
    }

    public function scopeColorPicker($query)
    {
        return $query->where('type', self::COLOR_PICKER);
    }

    public function scopeNotColorPicker($query)
    {
        return $query->where('type', '!=', self::COLOR_PICKER);
    }

    public function isColorPicker(): bool
    {
        return $this->type === self::COLOR_PICKER;
    }

    public function scopeDynamic($query)
    {
        return $query->where('type', self::DYNAMIC);
    }

    public function scopeNotDynamic($query)
    {
        return $query->where('type', '!=', self::DYNAMIC);
    }

    public function isDynamic(): bool
    {
        return $this->type === self::DYNAMIC;
    }

    public function scopeInput($query)
    {
        return $query->where('type', self::INPUT);
    }

    public function scopeNotInput($query)
    {
        return $query->where('type', '!=', self::INPUT);
    }

    public function isInput(): bool
    {
        return $this->type === self::INPUT;
    }

    public function scopeSelect($query)
    {
        return $query->where('type', self::SELECT);
    }

    public function scopeNotSelect($query)
    {
        return $query->where('type', '!=', self::SELECT);
    }

    public function isSelect(): bool
    {
        return $this->type === self::SELECT;
    }

    public function scopeText($query)
    {
        return $query->where('type', self::TEXT);
    }

    public function scopeNotText($query)
    {
        return $query->where('type', '!=', self::TEXT);
    }

    public function isText(): bool
    {
        return $this->type === self::TEXT;
    }
}
