<?php

namespace Bongo\Setting\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Setting\Events\SchemaUpdated;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;

class SiteSchemaController extends AbstractController
{
    public function index(): View
    {
        return view('setting::backend.site_schema.index');
    }

    public function update(Request $request): RedirectResponse
    {
        event(new SchemaUpdated($request->get('custom_schema')));

        return redirect()
            ->route('backend.setting.site_schema.index')
            ->success(trans('setting::backend.update_success'));
    }
}
