<?php

namespace Bongo\Setting\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Setting\Actions\ClearCache;
use Bongo\Setting\Actions\CompileCss;
use Bongo\Setting\Actions\UpdateSettings;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;
use ScssPhp\ScssPhp\Exception\SassException;

class ThemeController extends AbstractController
{
    public function index(): View
    {
        return view('setting::backend.theme.index');
    }

    /**
     * @throws SassException
     */
    public function update(Request $request): RedirectResponse
    {
        UpdateSettings::execute($request->get('settings'));
        ClearCache::execute();
        (new CompileCss())->execute();

        return redirect()
            ->route('backend.setting.theme.index')
            ->success(trans('setting::backend.update_success'));
    }
}
