<?php

namespace Bongo\Setting\Listeners;

use Bongo\Gallery\Seeders\PackageSeeder;
use Bongo\Package\Models\Package;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Artisan;

class UpdateGalleryModuleStatus implements ShouldQueue
{
    public function handle($event): void
    {
        // If the gallery module setting has been updated
        if ($event->setting->full_key == 'package::gallery.gallery_module') {

            // Check if the module already exists
            if ($package = Package::where('key', 'gallery')->get()->first()) {
                $package->status = $event->setting->isEnabled() ? Package::ACTIVE : Package::INACTIVE;
                $package->save();

            } else { // This package must not exists
                Artisan::call('db:seed', ['--class' => PackageSeeder::class, '--force' => true]);
                Artisan::call('migrate', ['--path' => '/vendor/bongo/gallery/src/Migrations', '--force' => true]);
            }

            // Clear the package cache
            Artisan::call('cache:clear');
        }
    }
}
