<?php

namespace Bongo\Setting\Listeners;

use Bongo\OpenAI\Seeders\PackageSeeder;
use Bongo\Package\Models\Package;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Artisan;

class UpdateOpenAIModuleStatus implements ShouldQueue
{
    public function handle($event): void
    {
        // If the openai module setting has been updated
        if ($event->setting->full_key == 'package::openai.openai_module') {

            // Check if the module already exists
            if ($package = Package::where('key', 'openai')->get()->first()) {
                $package->status = $event->setting->isEnabled() ? Package::ACTIVE : Package::INACTIVE;
                $package->save();

            } else { // This package must not exist
                Artisan::call('db:seed', ['--class' => PackageSeeder::class, '--force' => true]);
            }

            // Clear the package cache
            Artisan::call('cache:clear');
        }
    }
}
