<?php

namespace Bongo\Setting\Models;

use Bongo\Builder\Facades\LayoutFacade;
use Bongo\Framework\Models\AbstractModel;
use Bongo\Framework\Traits\HasKey;
use Bongo\Setting\Interfaces\DataTypes;
use Bongo\Setting\Interfaces\Groups;
use Bongo\Setting\Interfaces\InputTypes;
use Bongo\Setting\Interfaces\Namespaces;
use Bongo\Setting\Traits\HasType;

class Setting extends AbstractModel implements DataTypes, Groups, InputTypes, Namespaces
{
    public const ENABLED = 1;
    public const DISABLED = 0;

    use HasKey;
    use HasType;

    /** @var array */
    protected $fillable = [
        'name',
        'key',
        'value',
        'rules',
        'options',
        'type',
        'data',
    ];

    /** @var array */
    protected $casts = [
        'options' => 'array',
    ];

    public function getFullKeyAttribute(): string
    {
        return "{$this->namespace}::{$this->group}.{$this->key}";
    }

    public function getDynamicOptions(): array
    {
        if ($this->full_key === 'theme::layout.header') {
            return LayoutFacade::findByCategory('headers')
                ->pluck('name', 'name')
                ->toArray();
        }
        if ($this->full_key === 'theme::layout.heading') {
            return LayoutFacade::findByCategory('headings')
                ->pluck('name', 'name')
                ->toArray();
        }
        if ($this->full_key === 'theme::layout.footer') {
            return LayoutFacade::findByCategory('footers')
                ->pluck('name', 'name')
                ->toArray();
        }

        return [];
    }

    public function isEnabled(): bool
    {
        return $this->isCheckbox()
            && (int) $this->value === Setting::ENABLED;
    }

    public function isDisabled(): bool
    {
        return $this->isCheckbox()
            && (int) $this->value === Setting::DISABLED;
    }
}
