@extends('framework::backend.layouts.app')

@section('content')
    <form method="POST" action="{{ route('backend.setting.estimate.update') }}">
        {{ csrf_field() }}

        @component('blade::content_header')
            {{ trans('setting::backend.edit') }}
            @slot('actions')
                @backButton(['name' => trans('setting::backend.index'), 'url' => route('backend.setting.index')])
                @saveButton(['name' => trans('setting::backend.update')])
            @endslot
        @endcomponent

        @component('blade::content_body')
            @include('setting::backend.partials.navigation')
            <div class="tabs-container">

                @if(empty(setting('system::credentials.google_maps_api_key')))
                    <div class="rounded-sm bg-yellow-100 p-4 mb-4 border border-yellow-400 shadow-sm">
                        <div class="flex">
                            <div class="flex-shrink-0">
                                <svg class="h-5 w-5 text-yellow-400" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd"
                                          d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z"
                                          clip-rule="evenodd"
                                    />
                                </svg>
                            </div>
                            <div class="ml-3">
                                <h3 class="text-sm leading-5 font-medium text-yellow-800">
                                    Google Maps API Key is required to display the radius map, please check System > Credentials.
                                </h3>
                            </div>
                        </div>
                    </div>
                @endif

                @if(empty(setting('system::credentials.google_geocoding_api_key')))
                    <div class="rounded-sm bg-red-100 p-4 mb-4 border border-red-400 shadow-sm">
                        <div class="flex">
                            <div class="flex-shrink-0">
                                <svg class="h-5 w-5 text-red-400" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd"
                                          d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                                          clip-rule="evenodd"
                                    />
                                </svg>
                            </div>
                            <div class="ml-3">
                                <h3 class="text-sm leading-5 font-medium text-yellow-800">
                                    Google Geocoding API Key is required to use the estimator tool, please check System > Credentials.
                                </h3>
                            </div>
                        </div>
                    </div>
                @endif

                <div class="md:grid md:grid-cols-2 md:gap-6">
                    @foreach(setting()->getByNamespace('estimate') as $group => $settings)
                        <div class="md:col-span-1">
                            @component('blade::card')
                                @slot('header')
                                    {{ ucwords(str_replace('_', ' ', $group)) }}
                                @endslot

                                {{-- Loop through the settings --}}
                                <div class="grid grid-cols-1 col-gap-4 row-gap-4 md:grid-cols-2">
                                    @foreach($settings as $key => $setting)
                                        <div class="col-span-1">
                                            @if($setting->isText())
                                                @include('setting::backend.partials.textarea')
                                            @elseif($setting->isCheckbox())
                                                @include('setting::backend.partials.checkbox')
                                            @elseif($setting->isColorPicker())
                                                @include('setting::backend.partials.color_picker')
                                            @elseif($setting->isDynamic())
                                                @include('setting::backend.partials.dynamic')
                                            @elseif($setting->isSelect())
                                                @include('setting::backend.partials.select')
                                            @else
                                                @include('setting::backend.partials.input')
                                            @endif
                                        </div>
                                    @endforeach

                                </div>
                            @endcomponent
                        </div>
                    @endforeach
                    @if(! empty($radiusMapUrl))
                        <div class="md:col-span-2">
                            @component('blade::card', ['class' => 'p-1'])
                                <img class="img-fluid" src="{{ $radiusMapUrl }}" alt="Map of areas">
                            @endcomponent
                        </div>
                    @endif
                </div>
            </div>
        @endcomponent

    </form>
@stop
