@php
    $shared = 'group inline-flex items-center py-3 px-1 mr-8 border-b-2 font-medium text-sm leading-5 focus:outline-none';
    $active = 'border-gray-500 text-gray-600 focus:text-gray-800 focus:border-gray-700';
    $inactive = 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 focus:text-gray-700 focus:border-gray-300';
@endphp

<div class="px-4 mb-6 bg-white shadow sm:px-6 sm:block sm:rounded-sm">
    <nav class="flex flex-wrap -mb-px">
        @if(user()->isDeveloper())
            <a href="{{ route('backend.setting.environment.index') }}"
               class="{{ $shared }} {{ route_is('backend.setting.environment') ? $active : $inactive }}"
            >
                <span>Env</span>
            </a>
            <a href="{{ route('backend.setting.client.index') }}"
               class="{{ $shared }} {{ route_is('backend.setting.client') ? $active : $inactive }}"
            >
                <span>Client</span>
            </a>
            <a href="{{ route('backend.setting.package.index') }}"
               class="{{ $shared }} {{ route_is('backend.setting.package') ? $active : $inactive }}"
            >
                <span>Package</span>
            </a>
            @if(package()->isEnabled('estimate'))
                <a href="{{ route('backend.setting.estimate.index') }}"
                   class="{{ $shared }} {{ route_is('backend.setting.estimate') ? $active : $inactive }}"
                >
                    <span>Estimate Areas</span>
                </a>
            @endif
            <a href="{{ route('backend.setting.system.index') }}"
               class="{{ $shared }} {{ route_is('backend.setting.system') ? $active : $inactive }}"
            >
                <span>System</span>
            </a>
            <a href="{{ route('backend.setting.theme.index') }}"
               class="{{ $shared }} {{ route_is('backend.setting.theme') ? $active : $inactive }}"
            >
                <span>Theme</span>
            </a>
            <a href="{{ route('backend.setting.site_css.index') }}"
               class="{{ $shared }} {{ route_is('backend.setting.site_css') ? $active : $inactive }}"
            >
                <span>Site Css</span>
            </a>
            <a href="{{ route('backend.setting.site_js.index') }}"
               class="{{ $shared }} {{ route_is('backend.setting.site_js') ? $active : $inactive }}"
            >
                <span>Site Js</span>
            </a>
            <a href="{{ route('backend.setting.site_schema.index') }}"
               class="{{ $shared }} {{ route_is('backend.setting.site_schema') ? $active : $inactive }}"
            >
                <span>Site Schema</span>
            </a>
        @else
            <a href="{{ route('backend.setting.client.index') }}"
               class="{{ $shared }} {{ route_is('backend.setting.client') ? $active : $inactive }}"
            >
                <span>Client</span>
            </a>
        @endif
    </nav>
</div>
