@extends('framework::backend.layouts.app')

@section('content')
    <form method="POST" action="{{ route('backend.setting.site_css.update') }}">
        {{ csrf_field() }}

        @component('blade::content_header')
            {{ trans('setting::backend.edit') }}
            @slot('actions')
                @backButton(['name' => trans('setting::backend.index'), 'url' => route('backend.setting.index')])
                @saveButton(['name' => trans('setting::backend.update')])
            @endslot
        @endcomponent

        @component('blade::content_body')
            @include('setting::backend.partials.navigation')
            <div class="tabs-container">
                <custom-css-editor css="{{ setting()->getCustomCss() }}"></custom-css-editor>
            </div>
        @endcomponent

    </form>
@stop
