@extends('framework::backend.layouts.app')

@section('content')
    <form method="POST" action="{{ route('backend.setting.site_js.update') }}">
        {{ csrf_field() }}

        @component('blade::content_header')
            {{ trans('setting::backend.edit') }}
            @slot('actions')
                @backButton(['name' => trans('setting::backend.index'), 'url' => route('backend.setting.index')])
                @saveButton(['name' => trans('setting::backend.update')])
            @endslot
        @endcomponent

        @component('blade::content_body')
            @include('setting::backend.partials.navigation')
            <div class="tabs-container">
                <custom-js-editor js="{{ setting()->getCustomJs() }}"></custom-js-editor>
            </div>
        @endcomponent

    </form>
@stop
