<?php

namespace Bongo\Setting\Actions;

use Bongo\Setting\Events\SettingUpdated;
use Bongo\Setting\Models\Setting;

class UpdateSettings
{
    public static function execute(array $settings): void
    {
        // For each setting update the value
        foreach ($settings as $id => $value) {

            // Find the setting
            if ($setting = Setting::find($id)) {

                // Check if it's been updated
                if ($setting->value != $value) {
                    $setting->value = $value;
                    $changes = $setting->getDiff();
                    $setting->save();
                    event(new SettingUpdated($setting, $changes));
                }
            }
        }
    }
}
