<?php

namespace Bongo\Setting\Http\Controllers\Backend;

use Bongo\Framework\Helpers\CloudFlare;
use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Setting\Actions\ClearCache;
use Illuminate\Http\RedirectResponse;

class CacheController extends AbstractController
{
    public function __invoke(): RedirectResponse
    {
        ClearCache::execute();

        // Make a http call to the cloudflare api to clear the cache
        if (config('cloudflare.enabled')) {
            $cloudflare = new CloudFlare();
            if ($cloudflare->hasValidCredentials() && $zoneId = $cloudflare->getZoneId()) {
                $cloudflare->clearCache($zoneId);
            }
        }

        return redirect()
            ->back()
            ->success('Application cache cleared!');
    }
}
