<?php

namespace Bongo\Setting\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Setting\Actions\CompileCss;
use Illuminate\Http\RedirectResponse;
use ScssPhp\ScssPhp\Exception\SassException;

class CssController extends AbstractController
{
    /**
     * @throws SassException
     */
    public function __invoke(): RedirectResponse
    {
        (new CompileCss())->execute();

        return redirect()
            ->back()
            ->success('CSS has been updated!');
    }
}
