<?php

namespace Bongo\Setting\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Setting\Actions\ClearCache;
use Bongo\Setting\Http\Requests\UpdateEnvironment;
use Bongo\Setting\Services\EnvironmentManager;
use Bongo\Setting\Services\RobotsManager;
use Illuminate\Http\RedirectResponse;
use Illuminate\View\View;

class EnvironmentController extends AbstractController
{
    public function index(): View
    {
        return view('setting::backend.environment.index')->with([
            'env' => (new EnvironmentManager())->getAsArray(),
        ]);
    }

    public function update(UpdateEnvironment $request): RedirectResponse
    {
        (new RobotsManager())->set($request);
        (new EnvironmentManager())->set($request);

        ClearCache::execute();

        return redirect()
            ->route('backend.setting.environment.index')
            ->success(trans('setting::backend.update_success'));
    }
}
