<?php

namespace Bongo\Setting\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Setting\Events\CssUpdated;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;

class SiteCssController extends AbstractController
{
    public function index(): View
    {
        return view('setting::backend.site_css.index');
    }

    public function update(Request $request): RedirectResponse
    {
        event(new CssUpdated($request->get('custom_css')));

        return redirect()
            ->route('backend.setting.site_css.index')
            ->success(trans('setting::backend.update_success'));
    }
}
