<?php

namespace Bongo\Setting\Listeners;

use Bongo\Estimate\Seeders\PackageSeeder;
use Bongo\Package\Models\Package;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Artisan;

class UpdateEstimateModuleStatus implements ShouldQueue
{
    public function handle($event): void
    {
        // If the estimate module setting has been updated
        if ($event->setting->full_key == 'package::estimate.estimate_module') {

            // Check if the module already exists
            if ($package = Package::where('key', 'estimate')->get()->first()) {
                $package->status = $event->setting->isEnabled() ? Package::ACTIVE : Package::INACTIVE;
                $package->save();

            } else { // This package must not exist
                Artisan::call('db:seed', ['--class' => PackageSeeder::class, '--force' => true]);
                Artisan::call('migrate', ['--path' => '/vendor/bongo/estimate/src/Migrations', '--force' => true]);
            }

            // Clear the package cache
            Artisan::call('cache:clear');
        }
    }
}
