<?php

use Bongo\Setting\Http\Controllers\Backend\CacheController;
use Bongo\Setting\Http\Controllers\Backend\ClientController;
use Bongo\Setting\Http\Controllers\Backend\CssController;
use Bongo\Setting\Http\Controllers\Backend\EnvironmentController;
use Bongo\Setting\Http\Controllers\Backend\EstimateController;
use Bongo\Setting\Http\Controllers\Backend\PackageController;
use Bongo\Setting\Http\Controllers\Backend\SettingController;
use Bongo\Setting\Http\Controllers\Backend\SiteCssController;
use Bongo\Setting\Http\Controllers\Backend\SiteJsController;
use Bongo\Setting\Http\Controllers\Backend\SitemapController;
use Bongo\Setting\Http\Controllers\Backend\SiteSchemaController;
use Bongo\Setting\Http\Controllers\Backend\SystemController;
use Bongo\Setting\Http\Controllers\Backend\ThemeController;
use Illuminate\Support\Facades\Route;

Route::as('setting.')
    ->prefix('settings')
    ->group(function () {
        Route::get('/', [SettingController::class, 'index'])
            ->name('index');

        // Settings/environment/
        Route::as('environment.')
            ->middleware('developer')
            ->prefix('environment')
            ->group(function () {
                Route::get('/', [EnvironmentController::class, 'index'])
                    ->name('index');

                Route::post('update', [EnvironmentController::class, 'update'])
                    ->name('update');
            });

        // Settings/client/
        Route::as('client.')
            ->middleware(['manager'])
            ->prefix('client')
            ->group(function () {
                Route::get('/', [ClientController::class, 'index'])
                    ->name('index');

                Route::post('update', [ClientController::class, 'update'])
                    ->name('update');
            });

        // Settings/package/
        Route::as('package.')
            ->middleware('developer')
            ->prefix('package')
            ->group(function () {
                Route::get('/', [PackageController::class, 'index'])
                    ->name('index');

                Route::post('update', [PackageController::class, 'update'])
                    ->name('update');
            });

        // Settings/estimate/
        Route::as('estimate.')
            ->middleware('developer')
            ->prefix('estimate')
            ->group(function () {
                Route::get('/', [EstimateController::class, 'index'])
                    ->name('index');

                Route::post('update', [EstimateController::class, 'update'])
                    ->name('update');
            });

        // Settings/system/
        Route::as('system.')
            ->middleware('developer')
            ->prefix('system')
            ->group(function () {
                Route::get('/', [SystemController::class, 'index'])
                    ->name('index');

                Route::post('update', [SystemController::class, 'update'])
                    ->name('update');
            });

        // Settings/theme/
        Route::as('theme.')
            ->middleware('developer')
            ->prefix('theme')
            ->group(function () {
                Route::get('/', [ThemeController::class, 'index'])
                    ->name('index');

                Route::post('update', [ThemeController::class, 'update'])
                    ->name('update');
            });

        // Settings/site-css/
        Route::as('site_css.')
            ->middleware('developer')
            ->prefix('site-css')
            ->group(function () {
                Route::get('/', [SiteCssController::class, 'index'])
                    ->name('index');

                Route::post('update', [SiteCssController::class, 'update'])
                    ->name('update');
            });

        // Settings/site-js/
        Route::as('site_js.')
            ->middleware('developer')
            ->prefix('site-js')
            ->group(function () {
                Route::get('/', [SiteJsController::class, 'index'])
                    ->name('index');

                Route::post('update', [SiteJsController::class, 'update'])
                    ->name('update');
            });

        // Settings/site-schema/
        Route::as('site_schema.')
            ->middleware('developer')
            ->prefix('site-schema')
            ->group(function () {
                Route::get('/', [SiteSchemaController::class, 'index'])
                    ->name('index');

                Route::post('update', [SiteSchemaController::class, 'update'])
                    ->name('update');
            });

        Route::get('clear-cache', CacheController::class)
            ->middleware('developer')
            ->name('clear_cache');

        Route::get('compile-css', CssController::class)
            ->middleware('developer')
            ->name('compile_css');

        Route::get('generate-sitemap', SitemapController::class)
            ->middleware('developer')
            ->name('generate_sitemap');
    });
