@extends('framework::backend.layouts.app')

@section('content')
    <form method="POST" action="{{ route('backend.setting.package.update') }}">
        {{ csrf_field() }}

        @component('blade::content_header')
            {{ trans('setting::backend.edit') }}
            @slot('actions')
                @backButton(['name' => trans('setting::backend.index'), 'url' => route('backend.setting.index')])
                @saveButton(['name' => trans('setting::backend.update')])
            @endslot
        @endcomponent

        @component('blade::content_body')
            @include('setting::backend.partials.navigation')
            <div class="tabs-container">

                @if(package()->isEnabled('openai') && empty(setting('system::credentials.openai_api_key')))
                    <div class="rounded-sm bg-red-100 p-4 mb-4 border border-red-400 shadow-sm">
                        <div class="flex">
                            <div class="flex-shrink-0">
                                <svg class="h-5 w-5 text-red-400" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd"
                                          d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                                          clip-rule="evenodd"
                                    />
                                </svg>
                            </div>
                            <div class="ml-3">
                                <h3 class="text-sm leading-5 font-medium text-yellow-800">
                                    OpenAI API Key is required when module is enabled, please check System > Credentials.
                                </h3>
                            </div>
                        </div>
                    </div>
                @endif

                <div class="md:grid md:grid-cols-2 md:gap-6">
                    @foreach(setting()->getByNamespace('package') as $group => $settings)
                        <div class="md:col-span-1">

                            @component('blade::card')
                                @slot('header')
                                    {{ ucwords(str_replace('_', ' ', $group)) }}
                                @endslot

                                {{-- Loop through the settings --}}
                                <div class="grid grid-cols-1 col-gap-4 row-gap-4 md:grid-cols-2">
                                    @foreach($settings as $key => $setting)
                                        <div class="col-span-1">
                                            @if($setting->isText())
                                                @include('setting::backend.partials.textarea')
                                            @elseif($setting->isCheckbox())
                                                @include('setting::backend.partials.checkbox')
                                            @elseif($setting->isColorPicker())
                                                @include('setting::backend.partials.color_picker')
                                            @elseif($setting->isDynamic())
                                                @include('setting::backend.partials.dynamic')
                                            @elseif($setting->isSelect())
                                                @include('setting::backend.partials.select')
                                            @else
                                                @include('setting::backend.partials.input')
                                            @endif
                                        </div>
                                    @endforeach
                                </div>
                            @endcomponent

                        </div>
                    @endforeach
                </div>

            </div>
        @endcomponent

    </form>
@stop
