<?php

namespace Bongo\Sitemap;

use Bongo\Framework\Providers\AbstractServiceProvider;
use Bongo\Sitemap\Commands\GenerateSitemapCommand;
use Illuminate\Console\Scheduling\Schedule;

class SitemapServiceProvider extends AbstractServiceProvider
{
    protected string $module = 'sitemap';

    protected array $commands = [
        GenerateSitemapCommand::class,
    ];

    protected function bootCronSchedule(Schedule $schedule): void
    {
        parent::bootCronSchedule($schedule);

        $schedule->command('sitemap:generate')
            ->daily()
            ->environments(['production'])
            ->runInBackground()
            ->withoutOverlapping()
            ->appendOutputTo(base_path('storage/logs/sitemap.log'));
    }
}
