<?php

namespace Bongo\Sitemap\Actions;

use Bongo\Page\Models\Page;
use Bongo\Post\Models\Post;
use Bongo\Post\Models\PostCategory;
use Bongo\Project\Models\Project;
use Bongo\Project\Models\ProjectCategory;
use Bongo\Review\Models\Review;
use Spatie\Sitemap\Sitemap;
use Spatie\Sitemap\Tags\Url;

class GenerateSitemap
{
    public function execute(): void
    {
        // If the site is not public, do not generate the sitemap
        if (setting('system::misc.site_visibility') !== 'index') {
            return;
        }

        // Create the sitemap instance
        $siteMap = Sitemap::create();

        // Add the active web pages
        Page::query()
            ->with('images')
            ->active()
            ->where('meta_index', Page::INDEX)
            ->get()
            ->each(function (Page $page) use ($siteMap) {
                $url = $page->is_home_page == 1
                    ? (new Url('/'))->setPriority(1)
                    : (new Url($page->slug))->setPriority(0.9);

                if ($page->hasImages()) {
                    foreach ($page->images as $image) {
                        $url->addImage(url(config('image.prefix').'/'.$image->name));
                    }
                }
                $siteMap->add($url);
            });

        // Add the active blog posts & categories
        if (package()->isEnabled('post')) {
            Post::query()
                ->with('images')
                ->active()
                ->where('meta_index', Post::INDEX)
                ->get()
                ->each(function (Post $post) use ($siteMap) {
                    $url = (new Url(config('post.prefix').'/'.$post->slug))->setPriority(0.8);
                    if ($post->hasImages()) {
                        foreach ($post->images as $image) {
                            $url->addImage(url(config('image.prefix').'/'.$image->name));
                        }
                    }
                    $siteMap->add($url);
                });

            PostCategory::query()
                ->with('images')
                ->active()
                ->where('meta_index', PostCategory::INDEX)
                ->get()
                ->each(function (PostCategory $postCategory) use ($siteMap) {
                    $url = (new Url(config('post.category_prefix').'/'.$postCategory->slug))->setPriority(0.7);
                    if ($postCategory->hasImages()) {
                        foreach ($postCategory->images as $image) {
                            $url->addImage(url(config('image.prefix').'/'.$image->name));
                        }
                    }
                    $siteMap->add($url);
                });
        }

        // Add the active blog projects & categories
        if (package()->isEnabled('project')) {
            Project::query()
                ->with('images')
                ->active()
                ->where('meta_index', Project::INDEX)
                ->get()
                ->each(function (Project $project) use ($siteMap) {
                    $url = (new Url(config('project.prefix').'/'.$project->slug))->setPriority(0.8);
                    if ($project->hasImages()) {
                        foreach ($project->images as $image) {
                            $url->addImage(url(config('image.prefix').'/'.$image->name));
                        }
                    }
                    $siteMap->add($url);
                });

            ProjectCategory::query()
                ->with('images')
                ->active()
                ->where('meta_index', ProjectCategory::INDEX)
                ->get()
                ->each(function (ProjectCategory $projectCategory) use ($siteMap) {
                    $url = (new Url(config('project.category_prefix').'/'.$projectCategory->slug))->setPriority(0.7);
                    if ($projectCategory->hasImages()) {
                        foreach ($projectCategory->images as $image) {
                            $url->addImage(url(config('image.prefix').'/'.$image->name));
                        }
                    }
                    $siteMap->add($url);
                });
        }

        // Add the active reviews
        if (package()->isEnabled('review')) {
            Review::query()
                ->active()
                ->get()
                ->each(function (Review $review) use ($siteMap) {
                    $url = (new Url(config('review.prefix').'/'.$review->uuid))->setPriority(0.6);
                    $siteMap->add($url);
                });
        }

        // Save the sitemap.xml file to the public directory
        $siteMap->writeToFile(public_path('sitemap.xml'));
    }
}
